/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioArrivalOccurrence;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioStepSettings;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.apps.designer.VWSIMImportWorkflowDialog;
import filenet.sim.apps.designer.VWSIMReplaceWorkflowDialog;
import filenet.sim.toolkit.designer.VWSIMDesignerPreferences;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMImportConfirmationDialog;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMImportFailedDialog;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWSIMWorkflowListPanel
extends JPanel
implements IVWSIMPropertyChangeListener,
IVWToolbarBorderActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 7447L;
    protected VWToolbarBorder m_toolbarBorder = null;
    protected JList m_wflDefNameList = null;
    protected VWSIMPropertyData m_propertyData = null;

    public VWSIMWorkflowListPanel(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.createControls();
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public String getSelectedWorkflowName() {
        if (this.m_wflDefNameList != null) {
            return (String)this.m_wflDefNameList.getSelectedValue();
        }
        return null;
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 101: {
                this.reinitialize();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            if (event.getSource().equals(this.m_toolbarBorder)) {
                switch (event.getID()) {
                    case 65536: {
                        this.importWorkflow();
                        break;
                    }
                    case 0x10000000: {
                        this.deleteSelectedWorkflow();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            String name;
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolbarBorder.getClientPanel(), 2, 0x10000000));
            int nRowIndex = this.m_wflDefNameList.getSelectedIndex();
            if (nRowIndex != -1) {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolbarBorder.getClientPanel(), 1, 0x10000000));
            }
            if ((name = (String)this.m_wflDefNameList.getSelectedValue()) != null) {
                try {
                    VWWorkflowDefinition workflowDef = this.m_propertyData.getScenarioDefinition().getWorkflow(name).getWorkflowDefinition();
                    this.m_propertyData.setSelectedWorkflowDefinition(workflowDef);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
    }

    protected void importWorkflow() {
        try {
            VWSIMImportWorkflowDialog importDlg = new VWSIMImportWorkflowDialog(this.m_propertyData);
            importDlg.setVisible(true);
            if (importDlg.getExitStatus() == 0) {
                VWWorkflowDefinition[] workflowDefs = importDlg.getWorkflowDefinitions();
                if (workflowDefs != null) {
                    for (int nIndex = 0; nIndex < workflowDefs.length; ++nIndex) {
                        this.importGivenWorkflow(workflowDefs[nIndex]);
                    }
                }
                this.m_wflDefNameList.setSelectedIndex(this.m_wflDefNameList.getModel().getSize() - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void importGivenWorkflow(VWWorkflowDefinition newWorkflowDef) throws VWException {
        block14: {
            block15: {
                try {
                    try {
                        block16: {
                            if (newWorkflowDef == null || this.m_propertyData == null) break block14;
                            scenarioDef = null;
                            scenarioWFDef = null;
                            bWorkflowAlreadyImported = true;
                            try {
                                scenarioDef = this.m_propertyData.getScenarioDefinition();
                                scenarioWFDef = scenarioDef.getWorkflow(newWorkflowDef.getName());
                            }
                            catch (VWException ex) {
                                bWorkflowAlreadyImported = false;
                            }
                            if (bWorkflowAlreadyImported) break block16;
                            try {
                                workflowErrors = newWorkflowDef.validate(this.m_propertyData.getVWSession(), this.m_propertyData.getSystemConfiguration(), this.m_propertyData.getSdfFileContents());
                                if (workflowErrors == null || workflowErrors.length <= 0) ** GOTO lbl-1000
                                nWarningCount = VWSIMImportConfirmationDialog.getWarningCount(workflowErrors);
                                if (nWarningCount != workflowErrors.length) ** GOTO lbl-1000
                                dlg = new VWSIMImportConfirmationDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_workflowContainsWarningsTitle, workflowErrors);
                                dlg.show();
                                if (dlg.getExitStatus() == 1) {
                                }
                                ** GOTO lbl-1000
                            }
                            catch (VWException ex) {
                                VWDebug.logException(ex);
                                title = VWIDMBaseFactory.instance().getVWString(12).toString();
                                message = VWSIMResource.s_problemImportWorkflow.toString(ex.getLocalizedMessage());
                                VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), message, title, 1);
                            }
                            var9_16 = null;
                            this.m_propertyData.restoreDefaultCursor();
                            return;
lbl-1000:
                            // 1 sources

                            {
                                dlg = new VWSIMImportFailedDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_importFailedTitle, workflowErrors);
                                dlg.show();
                            }
                            break block15;
lbl-1000:
                            // 2 sources

                            {
                                this.m_propertyData.displayWaitCursor();
                                if (scenarioDef != null) {
                                    scenarioWFDef = scenarioDef.importWorkflow(newWorkflowDef, this.m_propertyData.getVWSession());
                                    this.importWorkflowResources(scenarioWFDef, false);
                                    this.addDefaultElements(scenarioWFDef);
                                    this.addCEObjectInfoObjects(newWorkflowDef, scenarioDef);
                                }
                                listModel = (DefaultListModel)this.m_wflDefNameList.getModel();
                                listModel.addElement(newWorkflowDef.getName());
                                this.m_propertyData.restoreDefaultCursor();
                                this.m_propertyData.setDirty();
                                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 125);
                            }
                            break block14;
                        }
                        this.replaceGivenWorkflow(scenarioWFDef, newWorkflowDef);
                        break block14;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        title = VWIDMBaseFactory.instance().getVWString(12).toString();
                        message = VWSIMResource.s_problemImportWorkflow.toString(ex.getLocalizedMessage());
                        VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), message, title, 1);
                        var9_19 = null;
                        this.m_propertyData.restoreDefaultCursor();
                        return;
                    }
                }
                catch (Throwable var8_21) {
                    var9_20 = null;
                    this.m_propertyData.restoreDefaultCursor();
                    throw var8_21;
                }
            }
            var9_17 = null;
            this.m_propertyData.restoreDefaultCursor();
            return;
        }
        var9_18 = null;
        this.m_propertyData.restoreDefaultCursor();
    }

    protected void replaceWorkflow() {
        block9: {
            try {
                VWWorkflowDefinition[] workflowDefs;
                VWScenarioDefinition scenarioDef;
                VWScenarioWorkflowDefinition scenarioWFDef;
                VWWorkflowDefinition workflowDef = this.m_propertyData.getSelectedWorkflowDefinition();
                if (workflowDef == null || (scenarioWFDef = (scenarioDef = this.m_propertyData.getScenarioDefinition()).getWorkflow(workflowDef.getName())) == null) break block9;
                VWSIMReplaceWorkflowDialog replaceDlg = new VWSIMReplaceWorkflowDialog(this.m_propertyData);
                replaceDlg.setVisible(true);
                if (replaceDlg.getExitStatus() != 0 || (workflowDefs = replaceDlg.getWorkflowDefinitions()) == null || workflowDefs.length <= 0) break block9;
                int nResult = 2;
                if (workflowDefs.length > 1) {
                    nResult = VWMessageDialog.showConfirmDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_replaceAllWorkflows, VWSIMResource.s_selectAnOption, 3);
                } else {
                    this.replaceGivenWorkflow(scenarioWFDef, workflowDefs[0]);
                }
                if (nResult == 2) {
                    for (int nIndex = 0; nIndex < workflowDefs.length; ++nIndex) {
                        if (VWStringUtils.compare(workflowDef.getName(), workflowDefs[nIndex].getName()) != 0) continue;
                        this.replaceGivenWorkflow(scenarioWFDef, workflowDefs[nIndex]);
                        break block9;
                    }
                    break block9;
                }
                for (int nIndex = 0; nIndex < workflowDefs.length; ++nIndex) {
                    try {
                        scenarioWFDef = scenarioDef.getWorkflow(workflowDefs[nIndex].getName());
                        if (scenarioWFDef == null) continue;
                        this.replaceGivenWorkflow(scenarioWFDef, workflowDefs[nIndex]);
                        continue;
                    }
                    catch (VWException ex) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceGivenWorkflow(VWScenarioWorkflowDefinition scenarioWFDef, VWWorkflowDefinition workflowDef) {
        try {
            block5: {
                try {
                    if (workflowDef == null || this.m_propertyData == null) break block5;
                    VWValidationError[] workflowErrors = workflowDef.validate(this.m_propertyData.getVWSession(), this.m_propertyData.getSystemConfiguration(), this.m_propertyData.getSdfFileContents());
                    if (workflowErrors == null || workflowErrors.length == 0) {
                        this.m_propertyData.displayWaitCursor();
                        VWWorkflowDefinition oldWFDef = scenarioWFDef.getWorkflowDefinition();
                        scenarioWFDef.setWorkflowDefinition(workflowDef, this.m_propertyData.getVWSession());
                        this.importWorkflowResources(scenarioWFDef, true);
                        this.updateScenarioDataFields(oldWFDef, scenarioWFDef);
                        this.m_propertyData.setSelectedWorkflowDefinition(scenarioWFDef.getWorkflowDefinition());
                        this.m_propertyData.restoreDefaultCursor();
                        this.m_propertyData.setDirty();
                        break block5;
                    }
                    VWSIMImportFailedDialog dlg = new VWSIMImportFailedDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_replaceFailedTitle, workflowErrors);
                    dlg.show();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
                    Object var6_8 = null;
                    this.m_propertyData.restoreDefaultCursor();
                }
            }
            Object var6_7 = null;
            this.m_propertyData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.m_propertyData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSelectedWorkflow() {
        try {
            block7: {
                try {
                    String name;
                    if (this.m_wflDefNameList == null || (name = (String)this.m_wflDefNameList.getSelectedValue()) == null) break block7;
                    this.m_propertyData.getScenarioDefinition().deleteWorkflow(name);
                    this.m_propertyData.setDirty();
                    int nIndex = this.m_wflDefNameList.getSelectedIndex();
                    DefaultListModel listModel = (DefaultListModel)this.m_wflDefNameList.getModel();
                    listModel.removeElementAt(nIndex);
                    if (nIndex > listModel.getSize() - 1) {
                        nIndex = listModel.getSize() - 1;
                    }
                    if (nIndex >= 0) {
                        this.m_wflDefNameList.setSelectedIndex(nIndex);
                    } else {
                        this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolbarBorder.getClientPanel(), 2, 0x10000000));
                        this.m_propertyData.setSelectedWorkflowDefinition(null);
                    }
                    this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 126);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var5_6 = null;
                    this.m_propertyData.restoreDefaultCursor();
                }
            }
            Object var5_5 = null;
            this.m_propertyData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_propertyData.restoreDefaultCursor();
            throw throwable;
        }
    }

    private void createControls() {
        this.m_toolbarBorder = new VWToolbarBorder(VWSIMResource.s_workflowsTab, 0x10010000);
        this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
        JPanel clientPanel = this.m_toolbarBorder.getClientPanel();
        clientPanel.setLayout(new BorderLayout());
        this.m_wflDefNameList = new JList(new DefaultListModel());
        this.m_wflDefNameList.setSelectionMode(0);
        this.m_wflDefNameList.addListSelectionListener(this);
        clientPanel.add((Component)new JScrollPane(this.m_wflDefNameList), "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_toolbarBorder, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitialize() {
        try {
            try {
                this.m_wflDefNameList.removeListSelectionListener(this);
                DefaultListModel listModel = (DefaultListModel)this.m_wflDefNameList.getModel();
                listModel.clear();
                VWScenarioDefinition scenarioDef = this.m_propertyData.getScenarioDefinition();
                VWScenarioWorkflowDefinition[] workflowDefs = scenarioDef.getWorkflows();
                if (workflowDefs != null) {
                    for (int i = 0; i < workflowDefs.length; ++i) {
                        listModel.addElement(workflowDefs[i].getWorkflowDefinition().getName());
                    }
                }
                Object var6_6 = null;
                this.m_wflDefNameList.addListSelectionListener(this);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var6_7 = null;
                this.m_wflDefNameList.addListSelectionListener(this);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_wflDefNameList.addListSelectionListener(this);
            throw throwable;
        }
        if (this.m_wflDefNameList.getModel().getSize() > 0) {
            this.m_wflDefNameList.setSelectedIndex(0);
        } else {
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolbarBorder.getClientPanel(), 2, 0x10000000));
            this.m_propertyData.setSelectedWorkflowDefinition(null);
        }
    }

    private void updateScenarioDataFields(VWWorkflowDefinition oldWfDef, VWScenarioWorkflowDefinition scenarioWfDef) {
        try {
            Object[] arrivalDefs = scenarioWfDef.getArrivals(3);
            if (arrivalDefs == null) {
                return;
            }
            for (int i = 0; i < arrivalDefs.length; ++i) {
                VWScenarioArrivalDefinition arrivalDef = (VWScenarioArrivalDefinition)arrivalDefs[i];
                if (arrivalDef == null) continue;
                boolean bReplace = this.m_propertyData.getReplaceInitialDataFields();
                if (bReplace) {
                    this.resetUDFs(arrivalDef);
                    continue;
                }
                this.replaceUDFs(oldWfDef, arrivalDef, scenarioWfDef);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void resetUDFs(VWScenarioArrivalDefinition arrivalDef) {
        try {
            arrivalDef.setFieldAssignments(null);
            this.m_propertyData.setDirty();
            return;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return;
        }
    }

    private void replaceUDFs(VWWorkflowDefinition oldWFDef, VWScenarioArrivalDefinition arrivalDef, VWScenarioWorkflowDefinition scenarioWfDef) {
        try {
            VWWorkflowDefinition newWFDef = scenarioWfDef.getWorkflowDefinition();
            VWFieldDefinition[] newFieldDefs = null;
            if (newWFDef != null) {
                newFieldDefs = newWFDef.getFields();
            }
            if (newFieldDefs == null) {
                VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_noDataFieldDefinitions, 1);
                this.resetUDFs(arrivalDef);
                return;
            }
            String[][] currentUDFs = null;
            if (arrivalDef != null) {
                currentUDFs = arrivalDef.getFieldAssignments();
            }
            if (currentUDFs == null) {
                return;
            }
            ArrayList<String[]> fieldsList = new ArrayList<String[]>();
            for (int i = 0; i < newFieldDefs.length; ++i) {
                int newFieldType;
                if (newFieldDefs[i].isArray() || ((newFieldType = newFieldDefs[i].getFieldType()) & 0x1F) == 0) continue;
                String newFieldName = newFieldDefs[i].getName();
                String newFieldValue = newFieldDefs[i].getStringValue();
                boolean bFound = false;
                for (int j = 0; j < currentUDFs.length; ++j) {
                    String name = currentUDFs[j][0];
                    VWFieldDefinition aField = oldWFDef.getField(name);
                    int type = aField.getFieldType();
                    String value = currentUDFs[j][1];
                    if (newFieldName.compareTo(name) != 0) continue;
                    bFound = true;
                    String[] field = new String[]{null, null};
                    field[0] = name;
                    field[1] = newFieldType == type ? value : newFieldValue;
                    fieldsList.add(field);
                }
                if (bFound) continue;
                String[] field = new String[]{null, null};
                field[0] = newFieldName;
                field[1] = newFieldValue;
                fieldsList.add(field);
            }
            if (arrivalDef != null) {
                String[][] fields = (String[][])fieldsList.toArray((T[])new String[0][0]);
                arrivalDef.setFieldAssignments(fields);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void importWorkflowResources(VWScenarioWorkflowDefinition scenarioWFDef, boolean bReimporting) {
        try {
            VWMapDefinition[] maps;
            VWWorkflowDefinition workflowDef = null;
            if (scenarioWFDef != null && (workflowDef = scenarioWFDef.getWorkflowDefinition()) != null && (maps = workflowDef.getMaps()) != null && maps.length > 0) {
                for (int i = 0; i < maps.length; ++i) {
                    String mapName = maps[i].getName();
                    VWMapNode[] mapNodes = maps[i].getSteps();
                    if (mapNodes == null || mapNodes.length <= 0) continue;
                    for (int j = 0; j < mapNodes.length; ++j) {
                        VWMapNode mapNode = mapNodes[j];
                        this.setDefaultRouteWeight(scenarioWFDef, mapName, mapNode, bReimporting);
                        int nStepType = VWStepUtils.getStepType(mapNode);
                        if (!VWStepUtils.isSubmapStep(nStepType)) {
                            this.setDefaultDuration(scenarioWFDef, mapName, mapNode, bReimporting);
                        }
                        if (!VWStepUtils.isGeneralStep(nStepType) && !VWStepUtils.isStartGeneralStep(nStepType)) continue;
                        this.createResourcesFromParticipants((VWStepDefinition)mapNode, workflowDef);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setDefaultRouteWeight(VWScenarioWorkflowDefinition scenarioWFDef, String mapName, VWMapNode mapNode, boolean bReimporting) {
        block14: {
            try {
                VWRouteDefinition[] routeDefs;
                if (scenarioWFDef == null || mapNode == null || (routeDefs = mapNode.getNextRoutes()) == null) break block14;
                VWScenarioStepSettings stepSettings = scenarioWFDef.getStepSettings(mapName, mapNode.getStepId());
                if (routeDefs.length == 1) {
                    stepSettings.setRouteWeight(routeDefs[0].getRouteId(), 100);
                    break block14;
                }
                if (routeDefs.length <= 1) break block14;
                if (bReimporting) {
                    boolean bAllZero = true;
                    for (int i = 0; i < routeDefs.length; ++i) {
                        if (stepSettings.getRouteWeight(routeDefs[i].getRouteId()) <= 0) continue;
                        bAllZero = false;
                        break;
                    }
                    if (!bAllZero) {
                        return;
                    }
                }
                switch (mapNode.getSplitType()) {
                    case 2: {
                        int nWeight = 100 / routeDefs.length;
                        int nReminder = 100 % routeDefs.length;
                        for (int nIndex = 0; nIndex < routeDefs.length; ++nIndex) {
                            Object value = this.getRouteWeight(routeDefs[nIndex]);
                            if (value != null && value instanceof Integer) {
                                stepSettings.setRouteWeight(routeDefs[nIndex].getRouteId(), (Integer)value);
                                continue;
                            }
                            if (nIndex == routeDefs.length - 1) {
                                stepSettings.setRouteWeight(routeDefs[nIndex].getRouteId(), nWeight + nReminder);
                                continue;
                            }
                            stepSettings.setRouteWeight(routeDefs[nIndex].getRouteId(), nWeight);
                        }
                        break;
                    }
                    case 1: {
                        for (int nIndex = 0; nIndex < routeDefs.length; ++nIndex) {
                            stepSettings.setRouteWeight(routeDefs[nIndex].getRouteId(), 100);
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private Object getRouteWeight(VWRouteDefinition routeDef) {
        try {
            if (routeDef == null) {
                return null;
            }
            VWAttributeInfo attributeInfo = routeDef.getAttributeInfo();
            if (attributeInfo != null) {
                return attributeInfo.getFieldValue("UI_RouteWeight");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void setDefaultDuration(VWScenarioWorkflowDefinition scenarioWFDef, String mapName, VWMapNode mapNode, boolean bReimporting) {
        try {
            if (scenarioWFDef != null && mapNode != null) {
                VWScenarioStepSettings stepSettings = scenarioWFDef.getStepSettings(mapName, mapNode.getStepId());
                VWScenarioTimeDuration duration = stepSettings.getDuration();
                if (bReimporting && !duration.getDuration().equals("0")) {
                    return;
                }
                String durationString = "0";
                Object value = this.getAttributeValue(mapNode, "UI_StepDurationValue");
                if (value != null && value instanceof String) {
                    durationString = (String)value;
                }
                int nUnits = 3;
                value = this.getAttributeValue(mapNode, "UI_StepDurationUnits");
                if (value != null && value instanceof Integer) {
                    switch ((Integer)value) {
                        case 1: {
                            nUnits = 1;
                            break;
                        }
                        case 2: {
                            nUnits = 2;
                            break;
                        }
                        case 3: {
                            nUnits = 3;
                            break;
                        }
                        case 4: {
                            int nDuration = Integer.parseInt(durationString) * 24;
                            durationString = Integer.toString(nDuration);
                            nUnits = 3;
                            break;
                        }
                        case 5: {
                            int nDuration = Integer.parseInt(durationString) * 24 * 5;
                            durationString = Integer.toString(nDuration);
                            nUnits = 3;
                            break;
                        }
                        case 6: {
                            int nDuration = Integer.parseInt(durationString) * 24 * 5 * 4;
                            durationString = Integer.toString(nDuration);
                            nUnits = 3;
                            break;
                        }
                    }
                }
                duration.setDuration(durationString);
                duration.setUnits(nUnits);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object getAttributeValue(VWMapNode mapNode, String fieldName) {
        try {
            if (mapNode == null) {
                return null;
            }
            VWAttributeInfo attributeInfo = mapNode.getAttributeInfo();
            if (attributeInfo != null) {
                return attributeInfo.getFieldValue(fieldName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void createResourcesFromParticipants(VWStepDefinition stepDef, VWWorkflowDefinition workflowDef) {
        try {
            VWParticipant[] stepParticipants = stepDef.getParticipants();
            VWParticipantItem[] participantItems = VWDefaultSessionProxy.getQuotedFullParticipantItems(stepParticipants, true);
            if (participantItems != null && participantItems.length > 0) {
                block13: for (int nIndex = 0; nIndex < participantItems.length; ++nIndex) {
                    String shortName = participantItems[nIndex].getShortName();
                    if (shortName.charAt(0) != '\"') {
                        shortName = "\"" + shortName + "\"";
                        stepParticipants[nIndex].setParticipantName(shortName);
                    }
                    String resourceName = shortName.substring(1, shortName.length() - 1);
                    int nParticipantType = participantItems[nIndex].getType();
                    if (VWStringUtils.compare(resourceName, "F_Originator") == 0) {
                        nParticipantType = 0;
                    }
                    switch (nParticipantType) {
                        case 2: {
                            String[] wfParticipants = this.getWorkflowGroupParticipants(resourceName, workflowDef);
                            int wfParticipantCount = 1;
                            if (wfParticipants != null) {
                                wfParticipantCount = wfParticipants.length;
                            }
                            try {
                                VWScenarioResourceDefinition grpResDef = this.m_propertyData.getScenarioDefinition().createResource(resourceName, 3, wfParticipantCount, 1.0, 1.0f);
                                this.m_propertyData.setDirty();
                                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 107, grpResDef);
                            }
                            catch (VWException ex) {}
                            continue block13;
                        }
                        case 1: {
                            try {
                                VWScenarioResourceDefinition grpResDef = this.m_propertyData.getScenarioDefinition().createResource(resourceName, 3, 2, 1.0, 1.0f);
                                this.m_propertyData.setDirty();
                                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 107, grpResDef);
                            }
                            catch (VWException ex) {}
                            continue block13;
                        }
                        case 0: 
                        case 4: {
                            try {
                                VWScenarioResourceDefinition resDef = this.m_propertyData.getScenarioDefinition().createResource(resourceName, 1, 1, 1.0, 1.0f);
                                this.m_propertyData.setDirty();
                                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 107, resDef);
                                continue block13;
                            }
                            catch (VWException ex) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String[] getWorkflowGroupParticipants(String groupName, VWWorkflowDefinition wfDef) {
        try {
            VWParticipant[] participants;
            VWFieldDefinition fieldDef = wfDef.getField(groupName);
            if (fieldDef.getFieldType() == 64 && (participants = (VWParticipant[])fieldDef.getValue()) != null && participants.length > 0) {
                String[] wflParticipants = new String[participants.length];
                for (int i = 0; i < participants.length; ++i) {
                    VWParticipant participant = participants[i];
                    if (participant == null) continue;
                    String name = participant.getParticipantName();
                    if (name.charAt(0) == '\"') {
                        name = name.substring(1, name.length() - 1);
                    }
                    wflParticipants[i] = name;
                }
                return wflParticipants;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void addDefaultElements(VWScenarioWorkflowDefinition scenarioWFDef) {
        try {
            VWSIMDesignerPreferences preferences = this.m_propertyData.getDesignerPreferences();
            if (preferences != null && preferences.getShouldCreateDefaultEntries()) {
                VWScenarioTimeDuration duration = new VWScenarioTimeDuration("0", 3);
                VWScenarioArrivalOccurrence occurrence = new VWScenarioArrivalOccurrence(1, "0", null, duration, null);
                VWScenarioTimeDuration startDuration = new VWScenarioTimeDuration("0", 3);
                scenarioWFDef.createArrival(VWSIMResource.s_defaultArrivalName, startDuration, occurrence, null, null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addCEObjectInfoObjects(VWWorkflowDefinition newWorkflowDef, VWScenarioDefinition scenarioDef) throws VWException {
        VWFieldDefinition[] fieldDefs = newWorkflowDef.getFields();
        if (fieldDefs != null) {
            for (int i = 0; i < fieldDefs.length; ++i) {
                if (fieldDefs[i].getFieldType() != 512) continue;
                scenarioDef.addCEObjectInfo(fieldDefs[i].getCEObjectInfo());
            }
        }
    }
}

